/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamusic.common.entity;

import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_3231;
import net.minecraft.class_4076;
import org.jetbrains.annotations.NotNull;
import xerca.xercamusic.client.MusicManagerClient;
import xerca.xercamusic.client.SoundController;
import xerca.xercamusic.common.Mod;
import xerca.xercamusic.common.MusicManager;
import xerca.xercamusic.common.NoteEvent;
import xerca.xercamusic.common.block.BlockInstrument;
import xerca.xercamusic.common.entity.Entities;
import xerca.xercamusic.common.item.IItemInstrument;
import xerca.xercamusic.common.item.Items;

public class EntityMusicSpirit
extends class_1297 {
    private class_1657 body;
    private class_1799 note;
    private IItemInstrument instrument;
    private final ArrayList<NoteEvent> notes = new ArrayList();
    private int length;
    private float volume;
    private byte bps;
    private boolean isPlaying = true;
    private BlockInstrument blockInstrument = null;
    private class_2338 blockInsPos = null;
    private SoundController soundController = null;

    public EntityMusicSpirit(class_1937 worldIn) {
        super(Entities.MUSIC_SPIRIT, worldIn);
    }

    public EntityMusicSpirit(class_1937 worldIn, class_1657 body, IItemInstrument instrument) {
        this(worldIn);
        this.body = body;
        this.instrument = instrument;
        this.setNoteFromBody();
        this.method_5814(body.method_23317(), body.method_23318(), body.method_23321());
    }

    public EntityMusicSpirit(class_1937 worldIn, class_1657 body, class_2338 blockInsPos, IItemInstrument instrument) {
        this(worldIn, body, instrument);
        this.setBlockPosAndInstrument(blockInsPos);
    }

    public EntityMusicSpirit(class_1299<EntityMusicSpirit> type, class_1937 world) {
        super(type, world);
    }

    private void setBlockPosAndInstrument(class_2338 pos) {
        class_2248 b;
        class_1937 level = this.method_37908();
        if (level.method_8398().method_12123(class_4076.method_18675((int)pos.method_10263()), class_4076.method_18675((int)pos.method_10260())) && (b = level.method_8320(pos).method_26204()) instanceof BlockInstrument) {
            BlockInstrument blockIns;
            this.blockInstrument = blockIns = (BlockInstrument)b;
            this.blockInsPos = pos;
            this.method_5814((double)pos.method_10263() + 0.5, (double)pos.method_10264() - 0.5, (double)pos.method_10260() + 0.5);
            return;
        }
        Mod.LOGGER.warn("Did not find a block instrument at the set position");
        this.blockInstrument = null;
        this.blockInsPos = null;
    }

    private boolean isBodyHandLegit() {
        class_1799 mainStack = this.body.method_6047();
        class_1799 offStack = this.body.method_6079();
        if (this.blockInstrument != null && this.blockInsPos != null) {
            return mainStack.method_7909() == Items.MUSIC_SHEET || offStack.method_7909() == Items.MUSIC_SHEET;
        }
        return offStack.method_7909() == Items.MUSIC_SHEET && mainStack.method_7909() == this.instrument;
    }

    private void setNoteFromBody() {
        if (this.body == null) {
            Mod.LOGGER.warn("Body is null in MusicSpirit setNoteFromBody");
            return;
        }
        class_1799 mainStack = this.body.method_6047();
        class_1799 offStack = this.body.method_6079();
        if (mainStack.method_7909() == Items.MUSIC_SHEET) {
            this.note = mainStack;
        } else if (offStack.method_7909() == Items.MUSIC_SHEET) {
            this.note = offStack;
        } else {
            Mod.LOGGER.warn("No music sheet found on body");
        }
    }

    protected void method_5749(@NotNull class_2487 tag) {
        NoteEvent.fillArrayFromNBT(this.notes, tag);
        this.length = tag.method_10550("l");
        this.bps = tag.method_10571("bps");
        this.volume = tag.method_10583("vol");
        this.isPlaying = tag.method_10577("playing");
        if (tag.method_10545("bX") && tag.method_10545("bY") && tag.method_10545("bZ")) {
            this.setBlockPosAndInstrument(new class_2338(tag.method_10550("bX"), tag.method_10550("bY"), tag.method_10550("bZ")));
        }
    }

    protected void method_5652(@NotNull class_2487 tag) {
        NoteEvent.fillNBTFromArray(this.notes, tag);
        tag.method_10569("l", this.length);
        tag.method_10567("bps", this.bps);
        tag.method_10548("vol", this.volume);
        tag.method_10556("playing", this.isPlaying);
        if (this.blockInsPos != null) {
            tag.method_10569("bX", this.blockInsPos.method_10263());
            tag.method_10569("bY", this.blockInsPos.method_10264());
            tag.method_10569("bZ", this.blockInsPos.method_10260());
        }
    }

    @NotNull
    public class_2596<class_2602> method_18002(@NotNull class_3231 serverEntity) {
        if (this.body == null) {
            Mod.LOGGER.error("Body is null on EntityMusicSpirit.getAddEntityPacket, this shouldn't happen!");
        }
        int data = this.blockInstrument == null ? this.body.method_5628() : -this.body.method_5628();
        return new class_2604((class_1297)this, serverEntity, data);
    }

    public void method_31471(@NotNull class_2604 packet) {
        super.method_31471(packet);
        int data = packet.method_11166();
        int bodyId = data > 0 ? data : -data;
        int biX = -1;
        int biY = -10000;
        int biZ = -1;
        if (data < 0) {
            biX = (int)Math.round(packet.method_11175() - 0.5);
            biY = (int)Math.round(packet.method_11174() + 0.5);
            biZ = (int)Math.round(packet.method_11176() - 0.5);
        }
        this.buildFromSpawnData(bodyId, biX, biY, biZ);
    }

    public void buildFromSpawnData(int bodyId, int bx, int by, int bz) {
        class_1297 ent = this.method_37908().method_8469(bodyId);
        if (ent instanceof class_1657) {
            this.body = (class_1657)ent;
        }
        if (by > -10000) {
            this.setBlockPosAndInstrument(new class_2338(bx, by, bz));
        }
        if (this.blockInsPos != null) {
            this.instrument = this.blockInstrument.getItemInstrument();
            this.setNoteFromBody();
        } else if (this.body != null) {
            class_1792 item = this.body.method_6047().method_7909();
            if (item instanceof IItemInstrument) {
                IItemInstrument ins;
                this.instrument = ins = (IItemInstrument)item;
                this.note = this.body.method_6079();
                this.method_5814(this.body.method_23317(), this.body.method_23318(), this.body.method_23321());
            } else {
                Mod.LOGGER.warn("Could not find instrument when spawning music spirit!");
                return;
            }
        }
        if (this.note != null) {
            UUID id = (UUID)this.note.method_57824(Items.SHEET_ID);
            int ver = (Integer)this.note.method_57825(Items.SHEET_VERSION, (Object)-1);
            this.length = (Integer)this.note.method_57825(Items.SHEET_LENGTH, (Object)0);
            if (id != null && ver >= 0 && this.length > 0) {
                this.bps = (Byte)this.note.method_57825(Items.SHEET_BPS, (Object)8);
                this.volume = ((Float)this.note.method_57825(Items.SHEET_VOLUME, (Object)Float.valueOf(1.0f))).floatValue();
                if (this.method_37908().field_9236) {
                    MusicManagerClient.checkMusicDataAndRun(id, ver, () -> {
                        MusicManager.MusicData data = MusicManagerClient.getMusicData(id, ver);
                        if (data != null) {
                            this.notes.addAll(data.notes());
                        }
                        this.soundController = new SoundController(this.notes, this.method_23317(), this.method_23318(), this.method_23321(), this.instrument, this.bps, this.volume, this.method_5628());
                        this.soundController.start();
                    });
                }
            }
        }
    }

    protected void method_5693(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_2945.class_9222 builder) {
    }

    public void method_36209() {
        if (this.soundController != null) {
            this.soundController.setStop();
        }
    }

    public void method_5773() {
        if (!this.method_37908().field_9236) {
            if (this.body == null || !this.isPlaying) {
                this.method_5650(class_1297.class_5529.field_26999);
                return;
            }
            if (!this.isBodyHandLegit()) {
                this.isPlaying = false;
                this.method_5650(class_1297.class_5529.field_26999);
                return;
            }
            if (this.blockInsPos != null && this.blockInstrument != null) {
                if (this.method_37908().method_8320(this.blockInsPos).method_26204() != this.blockInstrument) {
                    this.method_5650(class_1297.class_5529.field_26999);
                    return;
                }
                if (this.method_19538().method_1025(this.body.method_19538()) > 16.0) {
                    this.method_5650(class_1297.class_5529.field_26999);
                    return;
                }
            }
        }
        super.method_5773();
        if ((this.blockInsPos == null || this.blockInstrument == null) && this.body != null) {
            this.method_5814(this.body.method_23317(), this.body.method_23318(), this.body.method_23321());
            if (this.soundController != null) {
                this.soundController.setPos(this.method_23317(), this.method_23318(), this.method_23321());
            }
        }
    }

    public void setPlaying(boolean playing) {
        this.isPlaying = playing;
    }

    public class_1657 getBody() {
        return this.body;
    }
}

